#include <qei.h>
#include <p30fxxxx.h>

/* QEI is defined in following devices */
#if defined(__dsPIC30F2010__) || defined(__dsPIC30F3010__) || defined(__dsPIC30F4012__) || \
    defined(__dsPIC30F3011__) || defined(__dsPIC30F4011__) || defined(__dsPIC30F6010__) || \
    defined(__dsPIC30F5015__)

/*********************************************************************
* Function Name     : ConfigIntQEI()
* Description       : This function Configures QEI Interrupt and interrupt
*					  priority and clears the interrupt flag.
* Parameters        : unsigned int
* Return Value      : None
*********************************************************************/

void ConfigIntQEI(unsigned int config)
{
    IFS2bits.QEIIF = 0;                 /* clear Interrupt flag */
    IPC10bits.QEIIP = config & 0x07;    /* bits <2:0> is the priority*/
    IEC2bits.QEIIE = (config & 0x8)>>3; /* bit 3 is interrupt enable/diable */
}

#endif

